import 'package:get_it/get_it.dart';
import 'package:ezbusdriver/connection/all_apis.dart';
import 'package:ezbusdriver/utils/auth.dart';
import 'package:ezbusdriver/view_models/this_application_view_model.dart';

// Using GetIt is a convenient way to provide services and view models
// anywhere we need them in the app.
GetIt serviceLocator = GetIt.instance;

void setupServiceLocator() {
  // data base
  //serviceLocator.registerLazySingleton<DAO>(() => DAO());

  // API
  serviceLocator.registerLazySingleton<AllApis>(() => AllApis());

  // view models
  serviceLocator.registerLazySingleton<ThisApplicationViewModel>(() =>
      ThisApplicationViewModel());

  serviceLocator.registerLazySingleton<Auth>(() => Auth());

}
